<?php
/**
 * List View Single Event
 * This file contains three event in the list view
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/list/single-event.php
 *
 * @version 4.6.19
 *
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

$excerpt_words = 20;

// Setup an array of venue details for use later in the template
$venue_details = tribe_get_venue_details();

// The address string via tribe_get_venue_details will often be populated even when there's
// no address, so let's get the address string on its own for a couple of checks below.
$venue_address = tribe_get_address();

// Venue
$has_venue_address = ( ! empty( $venue_details['address'] ) ) ? ' location' : '';

$thumbnail = (isset($thumbnail_size) && $thumbnail_size) ? $thumbnail_size : 'post-thumbnail';

?>

<div class="event-three__single clearfix">
	<div class="event-three__wrap">
		<div class="event-three__image-inner">
			<?php echo tribe_event_featured_image( null, $thumbnail ); ?>
			<div class="event-three__date">
				<span class="month"><?php echo tribe_get_start_date(get_the_ID(), false, 'M'); ?></span>
				<span class="day"><?php echo tribe_get_start_date(get_the_ID(), false, 'd'); ?></span>
			</div>
		</div>
		<div class="event-three__content">
			<div class="event-three__address">
				<?php if ( $venue_details ) : ?>
					<span class="icon"><i class="fas fa-map-marker-alt"></i></span>
					<?php
						$address_delimiter = empty( $venue_address ) ? ' ' : ', ';

						// These details are already escaped in various ways earlier in the process.
						echo wp_kses( $venue_details['address'], false);
					?> 
				<?php endif; ?>
			</div>
			<h3 class="event-three__title">
				<a class="event-three__overlay" href="<?php echo esc_url( tribe_get_event_link() ); ?>">
					<?php the_title() ?>
				</a>	
			</h3>
			
		</div>
		<div class="event-three__action">
			<a class="btn-theme-2" href="<?php echo esc_url( tribe_get_event_link() ); ?>"><i class="fas fa-arrow-right"></i></a>
		</div>
	</div>
</div>