<?php
Redux::setSection( $opt_name, array(
	'title'   => esc_html__( 'Course Options', 'wellearn' ),
	'icon'    => 'el-icon-website',
	'fields'  => array(
		array(
		  	'id'  	=> 'course_archive_info',
		  	'type'  	=> 'info',
		  	'icon'  	=> true,
		  	'raw' 	=> '<h3 style="margin: 0;">' . esc_html__( 'Archive Course Page', 'wellearn' ) . '</h3>',
		),

		array(
			'id'			=> 'course_filter_layout',
			'type'		=> 'select',
			'title'     => esc_html__('Filter Layout', 'wellearn'),
		  	'options' 	=> array(
		  		'filter-disable'							=> esc_html__( 'Disable Filter', 'wellearn' ),
			  	'filter-layout-top layout-boxed'  	=> esc_html__( 'Filter Top', 'wellearn' ),
			  	'filter-layout-left'    				=> esc_html__( 'Filter Left', 'wellearn' ),
			  	'filter-layout-right'   				=> esc_html__( 'Filter Right', 'wellearn' )
		  ),
		),
		array(
			'id'			=> 'course_filter_style',
			'type'		=> 'select',
			'title'     => esc_html__('Select Input Style', 'wellearn'),
		  	'options' 	=> array(
		  		'filter-dropdow' => esc_html__('Filter Dropdow', 'wellearn'),
				'filter-list'    => esc_html__('Filter List', 'wellearn'),
		  	),
		  	'default'	=> 'filter-dropdow',
		  	'required'  => array('course_filter_layout', '=', array('filter-layout-left', 'filter-layout-right'))
		),
		array(
		  	'id' 			=> 'course_column_lg',
		  	'type' 		=> 'select',
		  	'title' 		=> esc_html__('Display Columns for Large Screen', 'wellearn'),
		  	'options' 	=> array(
			  	'1'      => '1',
			  	'2'      => '2',
			  	'3'      => '3',
			  	'4'      => '4',
			  	'5'      => '5',
			  	'6'      => '6'
		  ),
		  'default' => '3'
		),
		array(
		  	'id' 			=> 'course_column_md',
		  	'type' 		=> 'select',
		  	'title' 		=> esc_html__('Display Columns for Medium Screen', 'wellearn'),
		  	'options' 	=> array(
			  	'1'      => '1',
			  	'2'      => '2',
			  	'3'      => '3',
			  	'4'      => '4',
			  	'5'      => '5',
			  	'6'      => '6'
		  ),
		  'default' => '2'
		),
		array(
		  	'id' 			=> 'course_column_sm',
		  	'type' 		=> 'select',
		  	'title' 		=> esc_html__('Display Columns for Small Screen', 'wellearn'),
		  	'options' 	=> array(
			  	'1'      => '1',
			  	'2'      => '2',
			  	'3'      => '3',
			  	'4'      => '4',
			  	'5'      => '5',
			  	'6'      => '6'
		  	),
		  'default' => '2'
		),
		array(
		  	'id' 			=> 'course_column_xs',
		  	'type' 		=> 'select',
		  	'title' 		=> esc_html__('Display Columns for Extra Small Screen', 'wellearn'),
		  	'options' 	=> array(
			  	'1'      => '1',
			  	'2'      => '2',
			  	'3'      => '3',
			  	'4'      => '4',
			  	'5'      => '5',
			  	'6'      => '6',
		  	),
		  	'default' => '1'
		),

		array(
		  	'id' 			=> 'archive_course_sidebar',
		  	'type' 		=> 'select',
		  	'title' 		=> esc_html__('Courses Archive Page Sidebar Config', 'wellearn'),
		  	'options' 	=> array(
			 	'no-sidebars'     => esc_html__('No Sidebars', 'wellearn'),
			 	'left-sidebar'    => esc_html__('Left Sidebar', 'wellearn'),
			 	'right-sidebar'   => esc_html__('Right Sidebar', 'wellearn')
		  	),
		  	'default' => 'no-sidebars'
		),
	  	array(
			'id' 			=> 'archive_course_left_sidebar',
			'type' 		=> 'select',
			'title' 		=> esc_html__('Courses Archive Page Left Sidebar', 'wellearn'),
			'data'      => 'sidebars',
			'default' 	=> 'archive_course_sidebar'
	  	),
		array(
			'id' 				=> 'archive_course_right_sidebar',
			'type' 			=> 'select',
			'title' 			=> esc_html__('Courses Archive Page Right Sidebar', 'wellearn'),
			'data'      	=> 'sidebars',
			'default' 		=> 'archive_course_sidebar'
		),
	)
));