<?php
/**
 * Header buttons markup file.
 *
 * @package colormag
 *
 * TODO: @since.
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$button_enable = get_theme_mod( 'colormag_enable_header_button' );

$button_text   = get_theme_mod( 'colormag_header_button_text', 'Button 1' );
$button_link   = get_theme_mod( 'colormag_header_button_link' );
$button_icon   = get_theme_mod( 'colormag_header_button_icon', 'fa-solid fa-star' );
$button_preset = get_theme_mod( 'colormag_header_button_preset', 'default' );
$button_target = get_theme_mod( 'colormag_header_button_target' ) ? ' target="_blank"' : '';

if ( $button_text ) :
	?>
	<div class="cm-header-buttons">
		<?php
		do_action( 'colormag_header_button_start' );

		if ( $button_text ) {
			?>

			<div class="cm-header-button cm-header-button--1">
				<a class="cm-button <?php echo 'cm-button-' . $button_preset; ?>" href="<?php echo esc_url( $button_link ); ?>"
					<?php echo esc_attr( $button_target ); ?>
					class="<?php echo colormag_css_class( 'colormag_header_button_class', false ); ?>">
					<?php
					if ( $button_icon && ( 'style-7' === $button_preset || 'style-8' === $button_preset ) ) {
						?>
						<span class="cm-button-icon">
							<i class="<?php echo esc_attr( $button_icon ); ?>"></i>
						</span>
						<?php
					}
					?>
					<?php echo esc_html( $button_text ); ?>
					<?php
					if ( $button_icon && ( 'style-4' === $button_preset || 'style-5' === $button_preset || 'style-6' === $button_preset || 'style-9' === $button_preset ) ) {
						?>
						<span class="cm-button-icon">
							<i class="<?php echo esc_attr( $button_icon ); ?>"></i>
						</span>
						<?php
					}
					?>
				</a>
			</div>

			<?php
		}

		do_action( 'colormag_header_button_end' );
		?>

	</div> <!-- /.cm-header-buttons -->
	<?php
endif;
