<?php

$options = apply_filters(
	'colormag_header_divider_1_options',
	array(
		'colormag_header_divider_1_general_heading' => array(
			'type'         => 'customind-accordion',
			'title'        => esc_html__( 'Divider 1', 'colormag' ),
			'section'      => 'colormag_header_builder_divider_1',
			'sub_controls' => apply_filters(
				'colormag_header_divider_1_controls',
				array(
					'colormag_header_divider_1_general_heading' => array(
						'type'    => 'customind-title',
						'title'   => esc_html__( 'General', 'colormag' ),
						'section' => 'colormag_header_builder_divider_1',
					),
					'colormag_header_divider_1_layout'    => array(
						'default' => 'vertical',
						'type'    => 'customind-toggle-button',
						'title'   => esc_html__( ' Layout', 'colormag' ),
						'section' => 'colormag_header_builder_divider_1',
						'choices' => array(
							'horizontal' => esc_html__( 'Horizontal', 'colormag' ),
							'vertical'   => esc_html__( 'Vertical', 'colormag' ),
						),
					),
					'colormag_header_divider_1_style'     => array(
						'type'    => 'customind-toggle-button',
						'title'   => esc_html__( ' Style', 'colormag' ),
						'section' => 'colormag_header_builder_divider_1',
						'choices' => array(
							'solid'  => esc_html__( 'Solid', 'colormag' ),
							'dashed' => esc_html__( 'Dashed', 'colormag' ),
							'dotted' => esc_html__( 'Dotted', 'colormag' ),
							'double' => esc_html__( 'Double', 'colormag' ),
						),
					),
					'colormag_header_divider_1_color'     => array(
						'title'     => esc_html__( 'Color', 'colormag' ),
						'default'   => '',
						'type'      => 'customind-color',
						'section'   => 'colormag_header_builder_divider_1',
						'transport' => 'postMessage',
					),
					'colormag_header_divider_1_thickness' => array(
						'default'     => array(
							'size' => 1,
							'unit' => 'px',
						),
						'type'        => 'customind-slider',
						'title'       => esc_html__( 'Thickness', 'colormag' ),
						'section'     => 'colormag_header_builder_divider_1',
						'units'       => array( 'px' ),
						'defaultUnit' => 'px',
						'input_attrs' => array(
							'min'  => 0,
							'max'  => 50,
							'step' => 1,
						),
					),
					'colormag_header_divider_1_size'      => array(
						'default'     => array(
							'size' => 32,
							'unit' => 'px',
						),
						'type'        => 'customind-slider',
						'title'       => esc_html__( 'Size', 'colormag' ),
						'section'     => 'colormag_header_builder_divider_1',
						'units'       => array( 'px' ),
						'defaultUnit' => 'px',
						'input_attrs' => array(
							'min'  => 0,
							'max'  => 500,
							'step' => 1,
						),
					),
					'colormag_header_divider_1_margin'    => array(
						'default'     => array(
							'top'    => '',
							'right'  => '',
							'bottom' => '',
							'left'   => '',
							'unit'   => 'px',
						),
						'type'        => 'customind-dimensions',
						'title'       => esc_html__( 'Margin', 'colormag' ),
						'section'     => 'colormag_header_builder_divider_1',
						'transport'   => 'postMessage',
						'units'       => array( 'px', 'em' ),
						'defaultUnit' => 'px',
					),
				),
			),
			'collapsible'  => apply_filters( 'colormag_header_divider_1_accordion_collapsible', false ),
		),
	)
);

colormag_customind()->add_controls( $options );
