<?php
$container_layout_choices = apply_filters(
	'colormag_container_layout_choices',
	array(
		'default'                      => array(
			'label' => 'Inherit',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/inherit.svg',
		),
		'no_sidebar_full_width'        => array(
			'label' => 'Normal',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/normal.svg',
		),
		'no_sidebar_content_centered'  => array(
			'label' => 'Narrow',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/narrow.svg',
		),
		'no_sidebar_content_stretched' => array(
			'label' => 'Full Width',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/full-width.svg',
		),
	)
);

$sidebar_layout_choices = apply_filters(
	'colormag_site_layout_choices',
	array(
		'default'       => array(
			'label' => 'Inherit',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/inherit.svg',
		),
		'no_sidebar'    => array(
			'label' => 'No Sidebar',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/no-sidebar.svg',
		),
		'right_sidebar' => array(
			'label' => 'Right Sidebar',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/right-sidebar.svg',
		),
		'left_sidebar'  => array(
			'label' => 'Left Sidebar',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/left-sidebar.svg',
		),
		'two_sidebars'  => array(
			'label' => 'Both Sidebar',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/both-sidebar.svg',
		),
	)
);

$options = array(
	'colormag_blog_container_tab_group'            => array(
		'type'    => 'customind-tabs',
		'title'   => esc_html__( 'Blog', 'colormag' ),
		'section' => 'colormag_blog_archive_section',
		'tabs'    => array(
			'general' => esc_html__( 'General', 'colormag' ),
			'style'   => esc_html__( 'Style', 'colormag' ),
		),
		'default' => 'general',
	),
	'colormag_blog_container_layout'               => array(
		'default'   => 'default',
		'type'      => 'customind-radio-image',
		'title'     => esc_html__( 'Container Layout', 'colormag' ),
		'section'   => 'colormag_blog_archive_section',
		'tab_group' => 'colormag_blog_container_tab_group',
		'tab'       => 'general',
		'choices'   => $container_layout_choices,
		'columns'   => 2,
		'priority'  => 10,
	),
	'colormag_blog_sidebar_layout_divider'         => array(
		'type'      => 'customind-divider',
		'variant'   => 'dashed',
		'tab_group' => 'colormag_blog_container_tab_group',
		'tab'       => 'general',
		'section'   => 'colormag_blog_archive_section',
	),
	'colormag_blog_sidebar_layout'                 => array(
		'default'    => 'default',
		'type'       => 'customind-radio-image',
		'title'      => esc_html__( 'Sidebar Layout', 'colormag' ),
		'section'    => 'colormag_blog_archive_section',
		'tab_group'  => 'colormag_blog_container_tab_group',
		'tab'        => 'general',
		'choices'    => $sidebar_layout_choices,
		'columns'    => 2,
		'priority'   => 10,
		'conditions' => array(
			'relation' => 'OR',
			'terms'    => array(
				// Simple condition
				array(
					'id'       => 'colormag_blog_container_layout',
					'operator' => '===',
					'value'    => 'no_sidebar_full_width',
				),
				// Nested condition
				array(
					'relation' => 'AND',
					'terms'    => array(
						array(
							'id'       => 'colormag_blog_container_layout',
							'operator' => '===',
							'value'    => 'default',
						),
						array(
							'id'       => 'colormag_global_container_layout',
							'operator' => '===',
							'value'    => 'no_sidebar_full_width',
						),
					),
				),
			),
		),
	),
	'colormag_blog_layout_divider'                 => array(
		'type'      => 'customind-divider',
		'variant'   => 'dashed',
		'tab'       => 'general',
		'tab_group' => 'colormag_blog_container_tab_group',
		'section'   => 'colormag_blog_archive_section',
	),
	'colormag_blog_layout'                         => array(
		'default'   => 'layout-1',
		'type'      => 'customind-radio-image',
		'tab'       => 'general',
		'title'     => esc_html__( 'Layout', 'colormag' ),
		'tab_group' => 'colormag_blog_container_tab_group',
		'section'   => 'colormag_blog_archive_section',
		'choices'   => apply_filters(
			'colormag_blog_layout_2_style_choices',
			array(
				'layout-1' => array(
					'label' => '',
					'url'   => COLORMAG_IMG_URL . '/blog/layout-2/layout-1.svg',
				),
				'layout-2' => array(
					'label' => '',
					'url'   => COLORMAG_IMG_URL . '/blog/layout-2/style-2.svg',
				),
			)
		),
	),
	'colormag_blog_layout_1_style'                 => array(
		'default'   => 'style-1',
		'type'      => 'customind-radio-image',
		'tab'       => 'general',
		'tab_group' => 'colormag_blog_container_tab_group',
		'title'     => esc_html__( 'Advanced Style', 'colormag' ),
		'section'   => 'colormag_blog_archive_section',
		'choices'   => apply_filters(
			'colormag_blog_layout_1_style_choices',
			array(
				'style-1' => array(
					'label' => '',
					'url'   => COLORMAG_IMG_URL . '/blog/layout-1/style-1.svg',
				),
				'style-2' => array(
					'label' => '',
					'url'   => COLORMAG_IMG_URL . '/blog/layout-1/style-2.svg',
				),
			)
		),
		'columns'   => 2,
		'condition' => array(
			'colormag_blog_layout' => 'layout-1',
		),
	),
	'colormag_blog_layout_2_style'                 => array(
		'default'   => 'style-1',
		'type'      => 'customind-radio-image',
		'tab'       => 'general',
		'tab_group' => 'colormag_blog_container_tab_group',
		'title'     => esc_html__( 'Advanced Style', 'colormag' ),
		'section'   => 'colormag_blog_archive_section',
		'choices'   => apply_filters(
			'colormag_blog_layout_2_style_choices',
			array(
				'style-1' => array(
					'label' => '',
					'url'   => COLORMAG_IMG_URL . '/blog/layout-2/style-1.svg',
				),
				'style-2' => array(
					'label' => '',
					'url'   => COLORMAG_IMG_URL . '/blog/layout-2/style-2.svg',
				),
			)
		),
		'columns'   => 2,
		'condition' => array(
			'colormag_blog_layout' => 'layout-2',
		),
	),
	'colormag_grid_layout_column'                  => array(
		'default'   => '2',
		'type'      => 'customind-select',
		'tab'       => 'general',
		'tab_group' => 'colormag_blog_container_tab_group',
		'title'     => esc_html__( 'Column', 'colormag' ),
		'section'   => 'colormag_blog_archive_section',
		'choices'   => array(
			'2' => esc_html__( '2', 'colormag' ),
			'3' => esc_html__( '3', 'colormag' ),
			'4' => esc_html__( '4', 'colormag' ),
		),
		'condition' => array(
			'colormag_blog_layout' => 'layout-2',
		),
	),
	'colormag_blog_featured_image_heading'         => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Featured Image', 'colormag' ),
		'tab'       => 'general',
		'tab_group' => 'colormag_blog_container_tab_group',
		'section'   => 'colormag_blog_archive_section',
	),
	'colormag_enable_featured_image_caption'       => array(
		'title'     => esc_html__( 'Show Caption', 'colormag' ),
		'default'   => false,
		'type'      => 'customind-toggle',
		'section'   => 'colormag_blog_archive_section',
		'tab_group' => 'colormag_blog_container_tab_group',
		'transport' => 'refresh',
		'tab'       => 'general',
		'partial'   => array(
			'selector'        => '.featured-image-caption',
			'render_callback' => array(
				'ColorMag_Customizer_Partials',
				'render_featured_image_caption',
			),
		),
	),
	'colormag_enable_lightbox_blog'                => array(
		'title'     => esc_html__( 'LightBox', 'colormag' ),
		'default'   => false,
		'type'      => 'customind-toggle',
		'tab_group' => 'colormag_blog_container_tab_group',
		'section'   => 'colormag_blog_archive_section',
		'transport' => 'refresh',
		'tab'       => 'general',
	),
	'colormag_featured_image_size'                 => array(
		'default'   => '',
		'type'      => 'customind-select',
		'title'     => esc_html__( 'Size', 'colormag' ),
		'tab_group' => 'colormag_blog_container_tab_group',
		'section'   => 'colormag_blog_archive_section',
		'tab'       => 'general',
		'choices'   => array(
			'post-small' => esc_html__( 'Small (130 * 90)', 'colormag' ),
			'medium'     => esc_html__( 'Medium ( 390 * 205 )', 'colormag' ),
			'small'      => esc_html__( 'Featured ( 800 * 445 )', 'colormag' ),
			'large'      => esc_html__( 'Large ( 1400 * 600 )', 'colormag' ),
		),
	),
	'colormag_blog_post_elements_heading'          => array(
		'type'        => 'customind-heading',
		'tab_group'   => 'colormag_blog_container_tab_group',
		'title'       => esc_html__( 'Post Elements', 'colormag' ),
		'section'     => 'colormag_blog_archive_section',
		'description' => esc_html__( 'Manage the post elements such as Post Format, Category, Title, Meta, Content, etc.', 'colormag' ),
		'tab'         => 'general',
	),
	'colormag_blog_post_elements'                  => array(
		'type'      => 'customind-sortable',
		'tab'       => 'general',
		'tab_group' => 'colormag_blog_container_tab_group',
		'section'   => 'colormag_blog_archive_section',
		'choices'   => array(
			'post_format' => esc_attr__( 'Post Format (Image)', 'colormag' ),
			'category'    => esc_attr__( 'Category', 'colormag' ),
			'title'       => esc_attr__( 'Title', 'colormag' ),
			'meta'        => esc_attr__( 'Meta Tags', 'colormag' ),
			'content'     => esc_attr__( 'Content', 'colormag' ),
		),
		'default'   => array(
			'post_format',
			'category',
			'title',
			'meta',
			'content',
		),
		'condition' => apply_filters( 'colormag_blog_post_elements_order', false ),
	),
	'colormag_blog_post_title_heading'             => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Post Title', 'colormag' ),
		'section'   => 'colormag_blog_archive_section',
		'tab_group' => 'colormag_blog_container_tab_group',
		'tab'       => 'general',
	),
	'colormag_blog_post_title_length'              => array(
		'title'       => esc_html__( 'Length', 'colormag' ),
		'default'     => '',
		'type'        => 'customind-text',
		'section'     => 'colormag_blog_archive_section',
		'transport'   => 'refresh',
		'tab'         => 'general',
		'tab_group'   => 'colormag_blog_container_tab_group',
		'input_attrs' => array(
			'type' => 'number',
		),
	),
	'colormag_blog_post_meta_heading'              => array(
		'type'        => 'customind-heading',
		'title'       => esc_html__( 'Post Meta', 'colormag' ),
		'section'     => 'colormag_blog_archive_section',
		'description' => esc_html__( 'Manage the post meta elements such as Categories, Author, Date, Comments, Tags, etc.', 'colormag' ),
		'tab'         => 'general',
		'tab_group'   => 'colormag_blog_container_tab_group',
	),
	'colormag_blog_post_meta_structure'            => array(
		'type'      => 'customind-sortable',
		'section'   => 'colormag_blog_archive_section',
		'tab'       => 'general',
		'tab_group' => 'colormag_blog_container_tab_group',
		'choices'   => array(
			'author'      => esc_attr__( 'Author', 'colormag' ),
			'date'        => esc_attr__( 'Date', 'colormag' ),
			'views'       => esc_attr__( 'Views', 'colormag' ),
			'comments'    => esc_attr__( 'Comments', 'colormag' ),
			'tags'        => esc_attr__( 'Tags', 'colormag' ),
			'read-time'   => esc_attr__( 'Reading Time', 'colormag' ),
			'edit-button' => esc_attr__( 'Edit button', 'colormag' ),
		),
		'default'   => array(
			'categories',
			'date',
			'author',
		),
		'condition' => apply_filters( 'colormag_post_meta_elements_title_order', false ),
	),
	'colormag_blog_post_date_heading'              => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Post Date', 'colormag' ),
		'section'   => 'colormag_blog_archive_section',
		'tab'       => 'general',
		'tab_group' => 'colormag_blog_container_tab_group',
	),
	'colormag_blog_post_date_type'                 => array(
		'default'   => 'post-date',
		'type'      => 'customind-select',
		'title'     => esc_html__( 'Type', 'colormag' ),
		'tab'       => 'general',
		'tab_group' => 'colormag_blog_container_tab_group',
		'section'   => 'colormag_blog_archive_section',
		'choices'   => array(
			'post-date'     => esc_html__( 'Post Date', 'colormag' ),
			'modified-date' => esc_html__( 'Modified Date', 'colormag' ),
			'both-date'     => esc_html__( 'Both Date', 'colormag' ),
		),
	),
	'colormag_blog_post_meta_date_style'           => array(
		'default'   => 'style-1',
		'type'      => 'customind-select',
		'title'     => esc_html__( 'Style', 'colormag' ),
		'section'   => 'colormag_blog_archive_section',
		'tab_group' => 'colormag_blog_container_tab_group',
		'tab'       => 'general',
		'choices'   => array(
			'style-1' => esc_html__( 'Style 1', 'colormag' ),
			'style-2' => esc_html__( 'Style 2', 'colormag' ),
		),
	),
	'colormag_blog_post_meta_author_title_heading' => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Author', 'colormag' ),
		'section'   => 'colormag_blog_archive_section',
		'tab_group' => 'colormag_blog_container_tab_group',
		'tab'       => 'general',
	),
	'colormag_blog_post_meta_author_style'         => array(
		'default'   => 'style-1',
		'type'      => 'customind-select',
		'title'     => esc_html__( 'Style', 'colormag' ),
		'section'   => 'colormag_blog_archive_section',
		'tab_group' => 'colormag_blog_container_tab_group',
		'tab'       => 'general',
		'choices'   => array(
			'style-1' => esc_html__( 'Style 1', 'colormag' ),
			'style-2' => esc_html__( 'Style 2', 'colormag' ),
		),
	),
	'colormag_blog_post_meta_separator_heading'    => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Post Meta Separator', 'colormag' ),
		'section'   => 'colormag_blog_archive_section',
		'tab_group' => 'colormag_blog_container_tab_group',
		'tab'       => 'general',
	),
	'colormag_blog_post_meta_separator_type'       => array(
		'default'   => 'default',
		'type'      => 'customind-select',
		'title'     => esc_html__( 'Type', 'colormag' ),
		'tab'       => 'general',
		'section'   => 'colormag_blog_archive_section',
		'tab_group' => 'colormag_blog_container_tab_group',
		'choices'   => array(
			'default'         => esc_html__( 'None', 'colormag' ),
			'vertical-line'   => esc_html__( 'Vertical Line', 'colormag' ),
			'horizontal-line' => esc_html__( 'Horizontal Line', 'colormag' ),
			'circle-fill'     => esc_html__( 'Circle Filled', 'colormag' ),
			'circle-border'   => esc_html__( 'Circle Bordered', 'colormag' ),
			'square-fill'     => esc_html__( 'Square Filled', 'colormag' ),
			'square-border'   => esc_html__( 'Square Bordered', 'colormag' ),
			'diamond-fill'    => esc_html__( 'Diamond Square Filled', 'colormag' ),
			'diamond-border'  => esc_html__( 'Diamond Square Bordered', 'colormag' ),
		),
	),
	'colormag_blog_post_meta_separator_color'      => array(
		'title'     => esc_html__( 'Color', 'colormag' ),
		'default'   => '',
		'type'      => 'customind-color',
		'tab_group' => 'colormag_blog_container_tab_group',
		'section'   => 'colormag_blog_archive_section',
		'tab'       => 'general',
		'condition' => array(
			'colormag_blog_post_meta_separator_type!' => 'default',
		),
	),
	'colormag_blog_content_heading'                => array(
		'type'      => 'customind-heading',
		'tab_group' => 'colormag_blog_container_tab_group',
		'title'     => esc_html__( 'Excerpt', 'colormag' ),
		'section'   => 'colormag_blog_archive_section',
		'tab'       => 'general',
	),
	'colormag_blog_content_excerpt_type'           => array(
		'default'   => 'excerpt',
		'type'      => 'customind-select',
		'tab'       => 'general',
		'tab_group' => 'colormag_blog_container_tab_group',
		'title'     => esc_html__( 'Type', 'colormag' ),
		'section'   => 'colormag_blog_archive_section',
		'choices'   => array(
			'excerpt' => esc_html__( 'Excerpt', 'colormag' ),
			'content' => esc_html__( 'Full Content', 'colormag' ),
		),
	),
	'colormag_excerpt_length_setting'              => array(
		'title'       => esc_html__( 'Length', 'colormag' ),
		'default'     => 20,
		'type'        => 'customind-text',
		'tab_group'   => 'colormag_blog_container_tab_group',
		'section'     => 'colormag_blog_archive_section',
		'transport'   => 'refresh',
		'tab'         => 'general',
		'input_attrs' => array(
			'type' => 'number',
		),
		'condition'   => array(
			'colormag_blog_content_excerpt_type' => 'excerpt',
		),
	),
	'colormag_excerpt_more_text'                   => array(
		'title'     => esc_html__( 'More Text', 'colormag' ),
		'default'   => '',
		'type'      => 'customind-text',
		'tab'       => 'general',
		'tab_group' => 'colormag_blog_container_tab_group',
		'section'   => 'colormag_blog_archive_section',
		'transport' => 'refresh',
		'condition' => array(
			'colormag_blog_content_excerpt_type' => 'excerpt',
		),
	),
	'colormag_read_more_heading'                   => array(
		'type'      => 'customind-heading',
		'tab_group' => 'colormag_blog_container_tab_group',
		'title'     => esc_html__( 'CTA', 'colormag' ),
		'section'   => 'colormag_blog_archive_section',
		'tab'       => 'general',
	),
	'colormag_cta_enable'                          => array(
		'title'     => esc_html__( 'Enable', 'colormag' ),
		'default'   => true,
		'type'      => 'customind-toggle',
		'tab_group' => 'colormag_blog_container_tab_group',
		'section'   => 'colormag_blog_archive_section',
		'transport' => 'refresh',
		'tab'       => 'general',
	),
	'colormag_read_more_text'                      => array(
		'title'     => esc_html__( 'Text', 'colormag' ),
		'default'   => 'Read More',
		'type'      => 'customind-text',
		'tab'       => 'general',
		'section'   => 'colormag_blog_archive_section',
		'tab_group' => 'colormag_blog_container_tab_group',
		'transport' => 'refresh',
		'condition' => array(
			'colormag_cta_enable' => true,
		),
		'partial'   => array(
			'selector'        => '.cm-entry-button span',
			'render_callback' => array(
				'ColorMag_Customizer_Partials',
				'render_read_more_text',
			),
		),
	),
	'colormag_archive_category_page_heading'       => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Category Page', 'colormag' ),
		'section'   => 'colormag_blog_archive_section',
		'tab_group' => 'colormag_blog_container_tab_group',
		'tab'       => 'general',
	),
	'colormag_category_posts_count'                => array(
		'title'     => esc_html__( 'Number of post', 'colormag' ),
		'default'   => -1,
		'type'      => 'customind-text',
		'section'   => 'colormag_blog_archive_section',
		'tab_group' => 'colormag_blog_container_tab_group',
		'transport' => 'refresh',
		'tab'       => 'general',
	),
	'colormag_pagination_heading'                  => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Pagination', 'colormag' ),
		'section'   => 'colormag_blog_archive_section',
		'tab_group' => 'colormag_blog_container_tab_group',
		'tab'       => 'general',
	),
	'colormag_enable_pagination'                   => array(
		'title'     => esc_html__( 'Enable', 'colormag' ),
		'default'   => true,
		'type'      => 'customind-toggle',
		'section'   => 'colormag_blog_archive_section',
		'tab_group' => 'colormag_blog_container_tab_group',
		'transport' => 'refresh',
		'tab'       => 'general',
	),
	'colormag_pagination_type'                     => array(
		'default'   => 'excerpt',
		'type'      => 'customind-select',
		'title'     => esc_html__( 'Type', 'colormag' ),
		'tab'       => 'general',
		'section'   => 'colormag_blog_archive_section',
		'tab_group' => 'colormag_blog_container_tab_group',
		'choices'   => array(
			'default'             => esc_html__( 'Default', 'colormag' ),
			'numbered_pagination' => esc_html__( 'Numbered', 'colormag' ),
			'infinite_scroll'     => esc_html__( 'Infinite Scroll', 'colormag' ),
		),
		'condition' => array(
			'colormag_enable_pagination' => true,
		),
	),
	'colormag_pagination_number_alignment'         => array(
		'default'   => 'left',
		'type'      => 'customind-select',
		'title'     => esc_html__( 'Type', 'colormag' ),
		'tab'       => 'general',
		'section'   => 'colormag_blog_archive_section',
		'tab_group' => 'colormag_blog_container_tab_group',
		'choices'   => array(
			'flex-start' => esc_html__( 'Left', 'colormag' ),
			'center'     => esc_html__( 'Center', 'colormag' ),
			'flex-end'   => esc_html__( 'Right', 'colormag' ),
		),
		'condition' => array(
			'colormag_enable_pagination' => true,
			'colormag_pagination_type'   => 'numbered_pagination',
		),
	),
	'colormag_infinite_scroll_type'                => array(
		'default'   => 'button',
		'type'      => 'customind-select',
		'title'     => esc_html__( 'Style', 'colormag' ),
		'section'   => 'colormag_blog_archive_section',
		'tab_group' => 'colormag_blog_container_tab_group',
		'tab'       => 'general',
		'choices'   => array(
			'button' => esc_html__( 'Button', 'colormag' ),
			'scroll' => esc_html__( 'Scroll', 'colormag' ),
		),
		'condition' => array(
			'colormag_pagination_type' => 'infinite_scroll',
		),
	),
	'colormag_blog_post_title_typography'          => array(
		'default'   => array(
			'font-family'    => 'inherit',
			'font-weight'    => '500',
			'font-size'      => array(
				'desktop' => array(
					'size' => '24',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => 'px',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => 'px',
				),
			),
			'line-height'    => array(
				'desktop' => array(
					'size' => '1.3',
					'unit' => '',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
		),
		'type'      => 'customind-typography',
		'transport' => 'postMessage',

		'tab'       => 'style',
		'title'     => esc_html__( 'Post Title', 'colormag' ),
		'section'   => 'colormag_blog_archive_section',
		'tab_group' => 'colormag_blog_container_tab_group',
	),
	'colormag_blog_post_title_divider'             => array(
		'type'      => 'customind-divider',
		'variant'   => 'dashed',
		'tab'       => 'style',
		'section'   => 'colormag_blog_archive_section',
		'tab_group' => 'colormag_blog_container_tab_group',
	),
	'colormag_blog_post_meta_color'                => array(
		'title'     => esc_html__( 'Post Meta Text Color', 'colormag' ),
		'default'   => '#71717A',
		'type'      => 'customind-color',
		'tab'       => 'style',
		'section'   => 'colormag_blog_archive_section',
		'tab_group' => 'colormag_blog_container_tab_group',
	),
	'colormag_blog_post_meta_typography'           => array(
		'default'   => array(
			'font-family'    => 'inherit',
			'font-weight'    => 'regular',
			'subsets'        => array( 'latin' ),
			'font-size'      => array(
				'desktop' => array(
					'size' => '12',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => 'px',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => 'px',
				),
			),
			'line-height'    => array(
				'desktop' => array(
					'size' => '1.6',
					'unit' => '-',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '-',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '-',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
		),
		'type'      => 'customind-typography',
		'tab'       => 'style',
		'title'     => esc_html__( 'Font', 'colormag' ),
		'section'   => 'colormag_blog_archive_section',
		'tab_group' => 'colormag_blog_container_tab_group',
	),
	'colormag_site_identity_navigation'            => array(
		'title'    => esc_html__( 'Site Identity', 'colormag' ),
		'type'     => 'customind-navigation',
		'section'  => 'title_tagline',
		'to'       => 'colormag_header_builder_logo',
		'nav_type' => 'section',
		'priority' => 1,
	),
	'colormag_site_identity_navigation_heading'    => array(
		'type'        => 'customind-heading',
		'title'       => esc_html__( 'Site Icon', 'colormag' ),
		'section'     => 'title_tagline',
		'priority'    => 2,
		'description' => esc_html__( 'The Site Icon is what you see in browser tabs, bookmark bars, and within the WordPress mobile apps. It should be square and at least 512 by 512 pixels.', 'colormag' ),
	),
);

colormag_customind()->add_controls( $options );
