<?php
/**
 * The sidebar containing the main widget area.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package blackvideo
 */


?>

<aside id="secondary" class="widget-area sidebar">

<?php
	$meta = get_post_meta( get_the_ID(), 'enjoyvideo_post_options', true );
	$duration = isset($meta['opt-duration']) ? $meta['opt-duration'] : '';
	$related_on = isset($meta['opt-related-on']) ? $meta['opt-related-on'] : true;
	$related_position = isset($meta['opt-related-position']) ? $meta['opt-related-position'] : 'sidebar';
	$single_related_position = isset($meta['opt-related-position']) ? $meta['opt-related-position'] : 'sidebar';
	$site_related_position = blackvideo_option('related-posts-position', 'sidebar');

	if ($single_related_position == 'sidebar') {
		$related_position = $site_related_position;
	} else {
		$related_position = $single_related_position;
	}
?>
<?php if ( is_single() && ( blackvideo_option('single-related-on', true) == true) && ($related_on == true) && ($related_position == 'sidebar') ) { ?>

<?php
	// Get the taxonomy terms of the current page for the specified taxonomy.
	$terms = wp_get_post_terms( get_the_ID(), 'category', array( 'fields' => 'ids' ) );

	// Bail if the term empty.
	if ( empty( $terms ) ) {
		return;
	}

	// Posts query arguments.
	if (blackvideo_option('related-type', 'category') == 'tag') { 

		$post_tag = get_the_tags ( $post->ID );
		// Define an empty array
		$ids = array();
		// Check if the post has any tags
		if ( $post_tag ) {
		    foreach ( $post_tag as $tag ) {
		        $ids[] = $tag->term_id; 
		    }
		}

		$query = array(
			'post__not_in' => array( get_the_ID() ),
		    'post_type' => 'post',
		    'tag__in'   => $ids,
		   	'posts_per_page' => blackvideo_option('related-num', 10), 
		);

	} else {

		$query = array(
			'post__not_in' => array( get_the_ID() ),
			'tax_query'    => array(
				array(
					'taxonomy' => 'category',
					'field'    => 'id',
					'terms'    => $terms,
					'operator' => 'IN'
				)
			),
			'posts_per_page' => blackvideo_option('related-num', 10),
			'post_type'      => 'post',
		);

	}

	// Allow dev to filter the query.
	$args = apply_filters( 'blackvideo_related_posts_args', $query );

	// The post query
	$related = new WP_Query( $args );

	if ( $related->have_posts() ) : $i = 1; ?>

		<div class="entry-related clear">
			<?php while ( $related->have_posts() ) : $related->the_post(); ?>
				<?php
					$meta = get_post_meta( get_the_ID(), 'enjoyvideo_post_options', true );
					$duration = isset($meta['opt-duration']) ? $meta['opt-duration'] : '';
				?>
				<div <?php post_class(); ?>>
					<?php if ( has_post_thumbnail() ) { ?>
						<a class="thumbnail-link" href="<?php the_permalink(); ?>">
							<div class="thumbnail-wrap">
								<?php 
									the_post_thumbnail('blackvideo_post_thumb'); 
								?>
							</div><!-- .thumbnail-wrap -->

							<?php if ( !empty($duration) ) { ?>
								<div class="video-duration">
									<?php echo $duration; ?>
								</div>
							<?php } ?>	

							<?php if( (blackvideo_has_embed_code() || blackvideo_has_embed()) && ( blackvideo_option('loop-play-on', false) == true ) ) { ?>
								<div class="icon-play"><i class="genericon genericon-play"></i></div>
							<?php } ?>						
						</a>
					<?php } ?>				
					<h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
					<div class="entry-meta">
						<span class="entry-views"><?php echo blackvideo_get_post_views(get_the_ID()); ?></span>
						<span class="sep"> &middot; </span>
						<span class="entry-date"><?php echo esc_html( human_time_diff(get_the_time('U'), current_time('timestamp')) ) . ' '.  esc_html( 'ago', 'blackvideo-pro' ); ?></span>
					</div><!-- .entry-meta -->		
				</div><!-- .hentry -->
			<?php $i++; endwhile; ?>
		</div><!-- .entry-related -->

	<?php endif;

	// Restore original Post Data.
	wp_reset_postdata();
?>

<?php } else { ?>

	<?php dynamic_sidebar( 'sidebar-1' ); ?>
	
<?php } ?>


</aside><!-- #secondary -->

